
CREATE OR REPLACE FUNCTION CREATETABLE() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	MSGFINAL TEXT := 'FOI CRIADA';
BEGIN 
	IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS 
						WHERE TABLE_NAME= 'glb_layout_filipeta_prc_filial') THEN 

		CREATE TABLE glb_layout_filipeta_prc_filial(
			cd_emp integer NOT NULL,
			cd_filial integer NOT NULL,
			cd_filipeta integer NOT NULL,
		CONSTRAINT glb_layout_filipeta_prc_filial_PKEY PRIMARY KEY (cd_emp,cd_filial,cd_filipeta),
		CONSTRAINT glb_layout_filipeta_prc_filial_FKEY FOREIGN KEY (cd_emp,cd_filipeta)
		REFERENCES glb_layout_filipeta (cd_emp,cd_filipeta) MATCH SIMPLE
		ON UPDATE NO ACTION ON DELETE NO ACTION
		)
			WITH (OIDS=FALSE);
	ELSE    
		MSGFINAL := 'A TABELA J EXISTE';
	END IF;

	RAISE NOTICE 'TABELA glb_layout_filipeta_prc_filial %', MSGFINAL::VARCHAR;

END; 
-- FIM BLOCO PRINCIPAL 
$BODY$ 
LANGUAGE PLPGSQL VOLATILE 
  COST 100; 
ALTER FUNCTION CREATETABLE() OWNER TO POSTGRES;
SELECT CREATETABLE(); 
DROP FUNCTION CREATETABLE();
